﻿/*	VERSION:   1.4
1.4		Added version numbers

AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		moveTimeout			Array + Functions to manage this command's timeout ID   (used to stop the script)
*/
#include "functions/once.as"
// run()
define_moveRelative = function( thisCommand_obj ){
	// var TRACE_SCRIPT = true;
	
	var prom = VOW.make();
	var nextEvent = once( prom.keep );		// calling nextEvent() calls prom.keep( true )
	
	
	if(TRACE_SCRIPT)
		trace("moveRelative");
	
	
	// assume strings are variable paths, and add brackets if they're missing
	if(typeof(thisCommand_obj.data.position.x)=="string")
		if(thisCommand_obj.data.position.x.charAt(0)!="[")
			thisCommand_obj.data.position.x = "["+thisCommand_obj.data.position.x+"]";
	if(typeof(thisCommand_obj.data.position.y)=="string")
		if(thisCommand_obj.data.position.y.charAt(0)!="[")
			thisCommand_obj.data.position.y = "["+thisCommand_obj.data.position.y+"]";
	
	
	// prepare to move
	var duration = thisCommand_obj.data.duration;
	var xStartPix = thisCommand_obj.sprite._x;
	var yStartPix = thisCommand_obj.sprite._y;
	var originalName = thisCommand_obj.sprite._name;
	
	
	// apply autoDirection
	// get direction traveled
	var xDist = Number( nestedEval( thisCommand_obj.data.position.x, "RAM", "_this" ) );
	var yDist = Number( nestedEval( thisCommand_obj.data.position.y, "RAM", "_this" ) );
	//var xDist = thisCommand_obj.data.position.x;
	//var yDist = thisCommand_obj.data.position.y;
	if(TRACE_SCRIPT)		trace("  intended destination ("+ (xStartPix + xDist) +", "+ (yStartPix + yDist) +")");
	
	
	// check for walls
	if(TRACE_SCRIPT)		trace(" hitWalls: " + thisCommand_obj.data.hitWalls);
	// check for sprites
	if(TRACE_SCRIPT)		trace(" hitSprites: " + thisCommand_obj.data.hitSprites);
	
	
	
	// if:  hit walls
	// changes:  xDist, yDist, duration
	if( (thisCommand_obj.data.hitWalls || thisCommand_obj.data.hitSprites)  &&  (xDist!==0  ||  yDist!==0)  ){
		// Shorten xDist, yDist to the last non-colliding coordinate
		if(TRACE_SCRIPT)		trace(" checking for collision");
		var fullDuration = duration;
		var fullPath_p = new flash.geom.Point( xDist, yDist );
		var clippedPath_p = getClippedPath( fullPath_p );
		// overwrite the xDist and yDist values to their last non-colliding values
		xDist = clippedPath_p.x;
		yDist = clippedPath_p.y;
		
		// scale the duration down relative to the new distance
		if( clippedPath_p.length > 0 ){
			var durationScale = clippedPath_p.length / fullPath_p.length;
			duration = fullDuration * durationScale;
		}else{
			duration = 0;
		}
		if( isNaN(duration) ){
			trace("ERROR:  Error while scaling duration.  Problem dividing clippedPath_p.length / fullPath_p.length.  fullPath_p.length is probably 0");
			duration = 0;
		}
		
		if(TRACE_SCRIPT)		trace("  clipped destination ("+ (xDist+xStartPix) +", "+ (yDist+yStartPix) +")");
	}// if:  hit walls
	
	
	
	// Check whether or not anything should happen
	var isMoving = !(xDist===0 && yDist===0);
	
	
	
	if(thisCommand_obj.data.autoDirection  &&  isMoving ){
		// compare x & y
		if( Math.abs(yDist) > Math.abs(xDist) ){// vert
			if( yDist < 0){// up
				thisCommand_obj.sprite.image.setParams({direction:"up"});
			}else{// down
				thisCommand_obj.sprite.image.setParams({direction:"down"});
			}// if:  up or down
		}else{// horz
			if( xDist < 0 ){// left
				thisCommand_obj.sprite.image.setParams({direction:"left"});
			}else{// right
				thisCommand_obj.sprite.image.setParams({direction:"right"});
			}// if:  left or right
		}// if:  vert or horz
	}// if:  autoDirection
	
	
	
	// apply autoAnim
	if(thisCommand_obj.data.autoAnim  &&  isMoving)
		thisCommand_obj.sprite.image.setParams({isAnimating:true});
	
	
	
	// prepare to move
	var endX = xStartPix + xDist;
	var endY = yStartPix + yDist;
	
	
	
	// if:   no duration
	// instantly done
	if(duration === 0){
		motionDone();
		// finish instantly
		return prom;
		//return VOW.make().keep();
	}// if:   no duration
	
	
	
	// slide position
	var react_to_unload = react.once().to("unload");
	// if(duration==0)
	// 	duration = 0.001;
	// add slideX and slideY variables into the affected sprite
	var slideX = thisCommand_obj.sprite.slideX = new mx.transitions.Tween( thisCommand_obj.sprite, "_x", null, xStartPix, endX, duration, true);
	var slideY = thisCommand_obj.sprite.slideY = new mx.transitions.Tween( thisCommand_obj.sprite, "_y", null, yStartPix, endY, duration, true);
	slideY.thisCommand_obj = thisCommand_obj;
	
	function motionDone( thisTween ){
		react_to_unload.disable();
		//var spriteRemoved = (!sameSprite  ||  thisCommand_obj.sprite.wasRemoved  ||  thisCommand_obj.sprite._name == undefined  ||  thisCommand_obj.sprite._name == "");
		var sameSprite = thisCommand_obj.sprite == SPRITES[originalName];
		var spriteRemoved = (!sameSprite);
		// var wasMoving = Boolean(slideX.onMotionFinished);
		slideX.onMotionFinished = null;
		slideY.onMotionFinished = null;
		
		// clean-up tween object
		slideX.stop();
		slideY.stop();
		delete slideX;
		delete slideY;
		delete thisCommand_obj.sprite.slideX;
		delete thisCommand_obj.sprite.slideY;
		
		if( !spriteRemoved )
		{// if:  sprite still exists
			// jump to destination
			thisCommand_obj.sprite._x = endX;
			thisCommand_obj.sprite._y = endY;
			// stop animating
			if(thisCommand_obj.data.autoAnim)		// ON
				thisCommand_obj.sprite.image.setParams({isAnimating:false});
			// if(wasMoving)		thisCommand_obj.sprite.broadcastMessage("onMoveFinish");
			thisCommand_obj.sprite.broadcastMessage("onMoveFinish");
		}// if:  sprite still exists
		
		// check timeout before continuing
		var timeoutExists = thisCommand_obj.moveTimeout.exists( thisCommand_obj.timeout );
		if( timeoutExists )
		{// if:  timeout hasn't been deleted
			// clearTimeout
			thisCommand_obj.moveTimeout.remove( thisCommand_obj.timeout );
			// run next command
			if(!spriteRemoved)
				nextEvent();
			else
				prom.doBreak();		// thisCommand_obj.abort();
		}// if:  timeout hasn't been deleted
		else{
			// if:  timeout is missing
			prom.doBreak();		// thisCommand_obj.abort();
		}
	}// motionDone()
	motionDone = once( motionDone );
	//slideX.onMotionFinished = motionDone;
	slideY.onMotionFinished = motionDone;
	react_to_unload.then = motionDone;
	
	
	
	// allow motion to be interrupted  (occurs during teleports for instance)
	slideY.onMotionChanged = function()
	{
		var thisCommand_obj = this.thisCommand_obj;
		//thisCommand_obj.sprite.gridCollide_obj.loop();	// update grid position
		thisCommand_obj.sprite.broadcastMessage("onMove", {x:thisCommand_obj.sprite._x, y:thisCommand_obj.sprite._y, sprite:thisCommand_obj.sprite});
		var timeoutExists = thisCommand_obj.moveTimeout.exists( thisCommand_obj.timeout );
		//var spriteRemoved = (!sameSprite  ||  thisCommand_obj.sprite.wasRemoved  ||  thisCommand_obj.sprite._name == undefined  ||  thisCommand_obj.sprite._name == "");
		var sameSprite = thisCommand_obj.sprite == SPRITES[originalName];
		var spriteRemoved = (!sameSprite);
		if(spriteRemoved)
			thisCommand_obj.sprite.resetToStartPosition();
		if( spriteRemoved || !timeoutExists ){
			motionDone( this );
		}
	}// during move()
	
	
	
	// wait a moment
	var dudFunction = function(){};
	var waitTime = duration*1000;		// convert seconds to milliseconds
	thisCommand_obj.timeout = setTimeout( dudFunction, waitTime, thisCommand_obj );		// artifically generate a timeout ID,  and internally store it
	thisCommand_obj.moveTimeout.addTimeout( thisCommand_obj.timeout );		// externally store wait timeout
	//thisCommand_obj.moveTimeout = thisCommand_obj.sprite.moveTimeout;		// allow this command to store its timeouts
	
	
	
	// hit detection
	function getClippedPath( fullPath_p ){
		var tileSize = MAP.tileSize || 16;
		var xDir = fullPath_p.x / Math.abs( fullPath_p.x ) || 0;
		var yDir = fullPath_p.y / Math.abs( fullPath_p.y ) || 0;
		// check each tile along the path for a collision value > 0
		// // divide the vector into 16px (tileSize) chunks that center on tiles
		// // // figure out chunk size
		var chunkSize_p = new flash.geom.Point();
		// // // // using a proportion formula
		var fullPath_x = Math.abs(fullPath_p.x);
		var fullPath_y = Math.abs(fullPath_p.y);
		if( fullPath_x > fullPath_y ){
			// horizontal orientation
			chunkSize_p.x = tileSize;
			chunkSize_p.y = fullPath_x * tileSize / (fullPath_y || 1);		// if the width is 16,  what should the height be?  (avoid dividing by 0)
		}else{
			// vertical orientation
			chunkSize_p.x = fullPath_y * tileSize / (fullPath_x || 1);		// if the height is 16,  what should the width be?  (avoid dividing by 0)
			chunkSize_p.y = tileSize;
		}
		chunkSize_p.x *= xDir;
		chunkSize_p.y *= yDir;
		if(TRACE_SCRIPT)		trace("chunkSize_p: " + chunkSize_p);
		
		/*	
		// process to reverse the length formula
		// ("length squared"  -  "tileSize squared"  =  "remaining side squared")  Then take the square root of the "remaining side squared" to get the "remaining side"
		// var remainingSide = (fullPath_p.length * fullPath_p.length)  -  tileSize * tileSize);
		var remainingSide = fullPath_p.length  -  tileSize;
		if( fullPath_p.x === 0 || fullPath_p.y === 0 )		remainingSide = 0;
		remainingSide = Math.sqrt( remainingSide );
		if( Math.abs(fullPath_p.x) > Math.abs(fullPath_p.y) ){
			// horizontal orientation
			chunkSize_p.x = tileSize;
			chunkSize_p.y = remainingSide;
		}else{
			// vertical orientation
			chunkSize_p.x = remainingSide;
			chunkSize_p.y = tileSize;
		}
		chunkSize_p.x *= xDir;
		chunkSize_p.y *= yDir;
		*/
		
		var numChunks = Math.round( fullPath_p.length / chunkSize_p.length );		// floor = ignore minor wall overlap,   ceil = prevent even a slight wall overlap,  round = happy medium?
		if( chunkSize_p.length === 0 )
			numChunks = 0;
		// for each:  chunk
		var collisionData = MAP.collision_array;
		
		for( var chIndex=0; chIndex<numChunks; chIndex++){
			var index = chIndex+1;
			var xCheckPix = xStartPix + (chunkSize_p.x * index);
			var yCheckPix = yStartPix + (chunkSize_p.y * index);
			var xCheckTile = Math.floor( xCheckPix / tileSize );
			var yCheckTile = Math.floor( yCheckPix / tileSize );
			
			if(TRACE_SCRIPT)		trace(" chunk-index #" + index + "  pixel("+xCheckPix+", "+yCheckPix+")  tile("+xCheckTile+", "+yCheckTile+")");
			if( isColliding( xCheckTile, yCheckTile ) ){
				if(TRACE_SCRIPT)		trace("  isColliding() is true");
				break;
			}
			if(TRACE_SCRIPT)		trace("  isColliding() is false");
			
			/*	
			// check the xtile and ytile value for each chunk
			var collisionValue = collisionData[ xCheckTile ][ yCheckTile ];
			if(TRACE_SCRIPT)
				trace(" tile #" + chIndex + "  ("+xCheckTile+", "+yCheckTile+")  collisionValue: " + collisionValue);
			// if:  a wall / map-edge is found,  then stop here.  The index will indicate how far this got
			if( collisionValue > 0  ||  collisionValue === undefined )
				break;
			*/
		}// for each:  chunk
		
		
		
		// check every pixel between the last non-colliding tile and the original destination
		var lastClearIndex = chIndex-1;
		if( lastClearIndex < 0 )
			lastClearIndex = 0;
		var lastClearPix = new flash.geom.Point();
		lastClearPix.x = lastClearIndex * chunkSize_p.x;
		lastClearPix.y = lastClearIndex * chunkSize_p.y;
		var lastClearLength = lastClearPix.length;
		var endLength = fullPath_p.length;
		var check_p = fullPath_p.clone();
		// for each pixel between the last known clear coordinate and the intended destination coordinate
		var pixInc = lastClearLength;
		for( pixInc = lastClearLength;  pixInc < endLength;  pixInc++ ){
			// copy the orginal vector and resize it to the location we want to check
			check_p = fullPath_p.clone();
			check_p.normalize( pixInc );
			var xCheckPix = check_p.x + xStartPix;
			var yCheckPix = check_p.y + yStartPix;
			var xCheckTile = Math.floor( xCheckPix / tileSize );
			var yCheckTile = Math.floor( yCheckPix / tileSize );
			
			if(TRACE_SCRIPT)		trace(" pix #" + pixInc + "  pixel("+xCheckPix+", "+yCheckPix+")  tile("+xCheckTile+", "+yCheckTile+")");
			if( isColliding( xCheckTile, yCheckTile ) ){
				if(TRACE_SCRIPT)		trace("  isColliding() is true");
				break;
			}
			if(TRACE_SCRIPT)		trace("  isColliding() is false");
			/*	
			var collisionValue = collisionData[ xCheckTile ][ yCheckTile ];
			if(TRACE_SCRIPT)
				trace(" pix #" + pixInc + "  pixel("+xCheckPix+", "+yCheckPix+")  tile("+xCheckTile+", "+yCheckTile+")  collisionValue: " + collisionValue);
			// if:  a wall / map-edge is found,  then stop here.
			if( collisionValue > 0  ||  collisionValue === undefined ){
				break;
			}
			*/
		}// for each pixel between the last known clear coordinate and the intended destination coordinate
		
		// overwrite the fullPath_p.x and fullPath_p.y values to their last non-colliding values
		var clippedPath_p = fullPath_p.clone();
		if( pixInc > 0 ){
			var lastValidLength = pixInc-1;
			clippedPath_p.normalize( lastValidLength );
		}else{
			// don't move
			clippedPath_p.x = 0;
			clippedPath_p.y = 0;
		}
		/*	
		// overwrite the xDist and fullPath_p.y values to their last non-colliding values
		if( pixInc > 0 ){
			var lastValidLength = pixInc-1;
			var clippedPath_p = fullPath_p.clone();
			clippedPath_p.normalize( lastValidLength );
			fullPath_p.x = clippedPath_p.x;
			fullPath_p.y = clippedPath_p.y;
		}else{
			// if:  no movement is possible
			fullPath_p.x = 0;
			fullPath_p.y = 0;
		}
		*/
		return clippedPath_p;
	}// getClippedPath()
	
	
	
	function isColliding( xTile, yTile ){
		if(TRACE_SCRIPT)		trace("  isColliding()");
		// thisCommand_obj.data.hitWalls || thisCommand_obj.data.hitSprites
		var collisionData = MAP.collision_array;
		
		if( thisCommand_obj.data.hitWalls ){
			var collisionValue = collisionData[ xTile ][ yTile ];
			if(TRACE_SCRIPT)		trace("    collisionValue: " + collisionValue);
			if( collisionValue > 0  ||  collisionValue === undefined )
				return true;
		}// if colliding with walls
		
		
		if( thisCommand_obj.data.hitSprites ){
			var allSpritesOnTile = SPRITE_GRID[ xTile ][ yTile ];
			for(var s=0; s<allSpritesOnTile.length; s++){
				var thisSprite = allSpritesOnTile[ s ];
				// don't collide with yourself
				if( thisSprite === _this )
					continue;
				if(TRACE_SCRIPT)		trace("    " + thisSprite._name + ".noCollide: " + thisSprite.noCollide);
				// if this sprite has collision  (collision is not turned off)
				if( thisSprite.noCollide !== true )
					return true;
			}// for each sprite on this tile
		}// if colliding with sprites (with hit-boxes)
		
		
		return false;
	}// isColliding()
	
	
	
	// wait for promise
	return prom;
}// define_moveRelative()